from scipy.spatial.distance import pdist, squareform
import pandas as pd
import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt
import sys

res1=sys.argv[1] #e.g.10kb
res2=sys.argv[2] #e.g.50kb, res2 should be coarser than res1
lcm= int(sys.argv[3]) #least common multiple, 50000
o = open('jaccard_{:}_vs_{:}.txt'.format(res1,res2),'w')
o.write('method\tchro\tone\ttwo\tintersection\tunion\tjaccard\n')
chros = ['chr'+str(i) for i in range(1,20)]

for other_timepoint in ['NPC','CN']:
	for chro in chros:
		one = pd.read_csv('output/{}/ESvs{}_{:}_{}.txt'.format(res1,other_timepoint,chro,res1),sep="\t")
		one = one.loc[(one.Differential == "Non-Differential") | (one.Enriched_In == "Matrix 1")]
		one = np.unique(np.trunc(one.Boundary/lcm))

		two = pd.read_csv('output/{}/ESvs{}_{:}_{}.txt'.format(res2,other_timepoint,chro,res2),sep="\t")
		two = two.loc[(two.Differential == "Non-Differential") | (two.Enriched_In == "Matrix 1")]
		two = np.unique(np.trunc(two.Boundary/lcm))

		u_cnt = np.union1d(one,two).shape[0]
		i_cnt = np.intersect1d(one,two).shape[0]
		o.write('TADCompare (ES vs {:})\t{:}\t{:}\t{:}\t{:}\t{:d}\t{:.3f}\n'.format(other_timepoint,chro,res1,res2,int(i_cnt),int(u_cnt),i_cnt/u_cnt))

o.close()
#print(squareform(pdist(sigs)))
#		cnt print= np.sum(sig, axis=0)
#		for i in range(sig.shape[1]):
#			o.write('{}{}\ttask{:d}\t{:d}\n'.format(config,test,i+1,int(cnt[i])))	

