import numpy as np
import sys

res1=sys.argv[1] #e.g.10kb
res2=sys.argv[2] #e.g.50kb, res2 should be coarser than res1
lcm= int(sys.argv[3]) #least common multiple, 50000
o = open('jaccard_{:}_vs_{:}.txt'.format(res1,res2),'w')
o.write('method\tchro\tone\ttwo\tintersection\tunion\tjaccard\n')
chros = ['chr'+str(i) for i in range(1,20)]

for chro in chros:
	one= np.loadtxt('output/{}_VCSQRT/ES_{:}_{}.txt'.format(res1,chro,res1),dtype=int,usecols=[1,2]).flatten()
	one = np.unique(np.trunc(one/lcm))
	two= np.loadtxt('output/{}_VCSQRT/ES_{:}_{}.txt'.format(res2,chro,res2),dtype=int,usecols=[1,2]).flatten()
	two = np.unique(np.trunc(two/lcm))
	u_cnt = np.union1d(one,two).shape[0]
	i_cnt = np.intersect1d(one,two).shape[0]
	o.write('SpectralTAD\t{:}\t{}\t{}\t{:d}\t{:d}\t{:.3f}\n'.format(chro,res1,res2,int(i_cnt),int(u_cnt),i_cnt/u_cnt))
o.close()
#print(squareform(pdist(sigs)))
#		cnt print= np.sum(sig, axis=0)
#		for i in range(sig.shape[1]):
#			o.write('{}{}\ttask{:d}\t{:d}\n'.format(config,test,i+1,int(cnt[i])))	

