import numpy as np
import pandas as pd

methods = ['grinch','spectraltad','tadcompare','tgif','topdom']

df = pd.DataFrame()

for method in methods:
	for pair in ['10kb_vs_25kb','10kb_vs_50kb','25kb_vs_50kb']:
		tmp = pd.read_csv('../{}/jaccard_{}.txt'.format(method,pair),sep="\t",index_col=False)
		tmp['pair'] = pair
		df = pd.concat((df,tmp))

df.to_csv('jaccard_score.txt',sep="\t",index=False)
