import pandas as pd
import numpy as np
import sys

compare = ['01vs21','02vs22']
control = ['01vs02','21vs22']
chroms = ['chr'+str(i) for i in range(1, 23)]

o = open('compare_against_control.txt','w')
o.write('compare\tcontrol\t|intersection|\tn\tfalse positive rate\n')
for chro in chroms:
    for com in compare:
        comset = pd.read_csv('output/output_{}/{}/rep1_vs_rep2_significantly_differential_boundary_regions.txt'.format(com, chro),usecols=[1],header=None,names=['coord'],sep="\t")
        n = comset.coord.values.shape[0]
        for con in control:
            conset = pd.read_csv('output/output_{}/{}/rep1_vs_rep2_significantly_differential_boundary_regions.txt'.format(con, chro),usecols=[1],header=None,names=['coord'],sep="\t")
            intersection = np.intersect1d(comset.coord.values,conset.coord.values)
            denom = intersection.shape[0]
            o.write('{}\t{}\t{:d}\t{:d}\t{:.3f}\n'.format(com,con,denom,n,denom/n))
o.close()
