import pandas as pd
import numpy as np
import sys

compare = ['01vs21','02vs22']
control = ['01vs02','21vs22']
chroms = ['chr'+str(i) for i in range(1, 23)]

o = open('compare_against_control.txt','w')
o.write('compare\tcontrol\t|intersection|\tn\tfalse positive rate\n')
for chro in chroms:
    for com in compare:
        comset = pd.read_csv('output/output_{}/{}_10kb.txt'.format(com, chro),usecols=["Boundary","Differential"],sep="\t")
        n = comset.Boundary.values.shape[0]
        print(n)
        comset = comset.loc[comset.Differential == "Differential"].copy()
        n = comset.Boundary.values.shape[0]
        print(n)
        for con in control:
            conset = pd.read_csv('output/output_{}/{}_10kb.txt'.format(con, chro),usecols=["Boundary","Differential"],sep="\t")
            conset = conset.loc[conset.Differential == "Differential"].copy()
            intersection = np.intersect1d(comset.Boundary.values,conset.Boundary.values)
            denom = intersection.shape[0]
            o.write('{}\t{}\t{:d}\t{:d}\t{:.3f}\n'.format(com,con,denom,n,denom/n))
o.close()
