import pandas as pd
import numpy as np
import sys

compare = [['01','21'],['02','22']]
control = [['01','02'],['21','22']]
chroms = ['chr'+str(i) for i in range(1, 23)]

o = open('compare_against_control.txt','w')
o.write('compare\tcontrol\t|intersection|\tn\tfalse positive rate\n')
for chro in chroms:
    boundaries = {}
    for day in [0,2]:
        for rep in [1,2]:
            tmp = pd.read_csv('output/day0{:d}_{}_10kb_rep{:d}.txt'.format(day,chro,rep),sep="\t",header=None,names=['chro','start','end'])
            boundaries['{:d}{:d}'.format(day,rep)] = tmp.start.values 

    for com in compare:
        comset = np.setxor1d(boundaries[com[0]],boundaries[com[1]]) 
        n = comset.shape[0]
        for con in control:
            conset = np.setxor1d(boundaries[con[0]],boundaries[con[1]]) 
            intersection = np.intersect1d(comset,conset)
            denom = intersection.shape[0]
            o.write('{}vs{}\t{}vs{}\t{:d}\t{:d}\t{:.3f}\n'.format(com[0],com[1],con[0],con[1],denom,n,denom/n))
o.close()
