import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42

df = pd.DataFrame()
for m in ['grinch','spectraltad','tadcompare','tgif','topdom']:
    tmp = pd.read_csv('{}/compare_against_control.txt'.format(m),sep="\t")
    tmp['method'] = m
    df = pd.concat((df,tmp))

sns.boxplot(data=df,x='method',y='false positive rate',showfliers=False)
plt.savefig('compare_against_control.pdf')
