import pandas as pd
import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt
import sys
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42

timepoints = ['day'+str(i) for i in [0,2,5,7,15,80]]
df = pd.read_csv('nucleotide_profile.txt',sep="\t",skiprows=1,index_col=False,usecols=[0,1,4], header=None,names=['chrom','start','GC%'])
df['GC%'] *= 100
bigdf = pd.DataFrame()
for c in range(1, 23):
	tmp = df.loc[df['chrom'] == 'chr'+str(c)].copy()
	comp = pd.read_csv('annotated/chr{:d}_compartment_annotation.txt'.format(c),sep="\t",index_col=False)
	tmp = pd.merge(tmp,comp,how='inner',on=['chrom','start'])
	bigdf = pd.concat((bigdf,tmp))

bigdf.dropna(inplace=True)
bigdf = pd.melt(bigdf, id_vars=['chrom','start','GC%'],value_vars=timepoints,var_name='timepoint',value_name='compartment',ignore_index=True)
print(bigdf)
sns.boxplot(data=bigdf,x='timepoint',y='GC%',hue='compartment',showfliers=False,hue_order=['A','B'])
plt.savefig('figures/gc_content.pdf'.format(c))


