import pandas as pd
import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt
import sys
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42

chrom = ['chr'+str(i) for i in range(1, 23)]
cells = [0,2,5,7,15,80]

#get h3k27ac per timepoint
chip = {}
for cell in cells:
	allchrom = pd.DataFrame()
	for chro in chrom:
		bed = pd.read_csv('bed/day00_{}_100kb.bed'.format(chro),sep="\t",header=None,usecols=[0,1],names=['chrom','start'],index_col=False)
		bed['h3k27ac'] = np.loadtxt('h3k27ac/D{:d}_{}_100kb.txt'.format(cell,chro))
		allchrom = pd.concat((allchrom,bed))
	chip[cell] = allchrom

#get compartment annotation across all timepoints
df = pd.DataFrame()
for c in chrom:
	bed = pd.read_csv('bed/day00_{}_100kb.bed'.format(c),sep="\t",header=None,usecols=[0,1],names=['chrom','start'],index_col=False)
	tmp = pd.read_csv('annotated/{}_compartment_annotation.txt'.format(c),sep="\t",index_col=False)
	bed = pd.merge(bed,tmp,how='inner',on=['chrom','start'])
	df = pd.concat((df,bed))

#merge h3kac with compartment groupings
finaldf = pd.DataFrame()
for c in cells:
	tmp = df[['chrom','start','day'+str(c)]].copy()
	tmp.rename(columns={'day'+str(c):'compartment'},inplace=True)
	tmp['timepoint'] = c
	tmp = pd.merge(tmp,chip[c],how='inner',on=['chrom','start'])
	finaldf = pd.concat((finaldf,tmp))

sns.boxplot(data=finaldf,x='timepoint',y='h3k27ac',hue='compartment',showfliers=False,hue_order=['A','B'])
plt.savefig('figures/h3k27ac.pdf')
