import pandas as pd
import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt
import sys
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42

chrom = ['chr'+str(i) for i in range(1, 23)]
cells = ['day0']

df = pd.DataFrame()
for c in chrom:
	bed = pd.read_csv('bed/day00_{}_100kb.bed'.format(c),sep="\t",header=None,usecols=[0,1],names=['chrom','start'],index_col=False)
	atac = np.loadtxt('atacseq/{}_100kb.txt'.format(c))
	bed['atac'] = atac
	tmp = pd.read_csv('annotated/{}_compartment_annotation.txt'.format(c),sep="\t",index_col=False)
	bed = pd.merge(bed,tmp,how='inner',on=['chrom','start'])
	df = pd.concat((df,bed))

for c in cells:
	tmp = df[['chrom','start',c,'atac']]
	sns.boxplot(data=tmp,x=c,y='atac',showfliers=False,order=['A','B'])
	plt.savefig('figures/per_compartment_{}.pdf'.format(c))
	plt.close()
