import pandas as pd
import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt
import sys
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42

for g in ['cluster','compartment']:
	for cell in ['day0']:
		df = pd.read_csv('mean_atac_per_{}/{}.txt'.format(g,cell),sep="\t",index_col='chrom')
		sns.heatmap(df,cmap='Greens',annot=True,fmt='.2f')
		plt.savefig('figures/mean_atac_per_{}_{}.pdf'.format(g,cell))
		plt.close()
