import numpy as np
import pandas as pd

chrom = ['chr'+str(i) for i in range(1, 23)]
cells = ['day0']
df = pd.DataFrame()
for c in chrom:
	bed = pd.read_csv('bed/day00_{}_100kb.bed'.format(c),sep="\t",header=None,usecols=[0,1],names=['chrom','start'],index_col=False)
	atac = np.loadtxt('atacseq/{}_100kb.txt'.format(c))
	bed['atac'] = atac
	tmp = pd.read_csv('annotated/{}_compartment_annotation.txt'.format(c),sep="\t",index_col=False)
	bed = pd.merge(bed,tmp,how='inner',on=['chrom','start'])
	df = pd.concat((df,bed))

for c in cells:
	tmp = df[['chrom','start',c,'atac']]
	tmp = tmp.groupby(['chrom',c])['atac'].mean().reset_index()	
	tmp = tmp.pivot(index='chrom',columns=c,values='atac').reset_index()
	tmp['chrom'] = tmp['chrom'].str.removeprefix('chr').astype(int)
	tmp.sort_values(by='chrom',inplace=True)
	tmp.to_csv('mean_atac_per_compartment/{}.txt'.format(c),sep="\t",index=False)


