import pandas as pd
import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt
import sys
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42

df = pd.read_csv('nucleotide_profile.txt',sep="\t",skiprows=1,index_col=False,usecols=[0,1,4,6,7,11], header=None,names=['#chro','start','GC%','C','G','N'])
bigdf = pd.DataFrame()
for c in range(1, 23):
	tmp = df.loc[df['#chro'] == 'chr'+str(c)].copy()
	comp = pd.read_csv('annotated/chr{:d}_compartment_annotation.txt'.format(c),sep="\t",index_col=False)
	comp['#chro'] = 'chr'+comp['chrom'].map(str)
	tmp = pd.merge(tmp,comp,how='inner',on=['#chro','start'])
	bigdf = pd.concat((bigdf,tmp))

bigdf.dropna(inplace=True)
bigdf['CG'] = bigdf.C + bigdf.G
bigdf['combo'] = comp.H1+comp.endoderm
for c in ['H1','endoderm']:
	agg = bigdf.groupby(['chrom',c])['GC%'].mean().reset_index()
	agg = agg.pivot(index='chrom',columns=c,values='GC%')
	agg *= 100
	sns.heatmap(agg,cmap='Purples',annot=True,fmt='.1f')
	plt.savefig('{}_gc_per_chrom.pdf'.format(c))
	plt.close()

	sns.boxplot(data=bigdf,x=c,y='GC%',showfliers=False)
	plt.savefig('{}_gc_content.pdf'.format(c))
	plt.close()


