import pandas as pd
import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt
import sys
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42

chrom = ['chr'+str(i) for i in range(1, 23)]
cells = ['H1','endoderm']
atac = {}
for c in cells:
	tmp = pd.read_csv('atacseq_chipseq_reads_coverage/{}_atacseq.bed'.format(c),sep="\t",header=None,usecols=[0,1,3],names=['chrom','start','atac'],index_col=False)
	atac[c] = tmp 

df = pd.DataFrame()
for c in chrom:
	tmp = pd.read_csv('annotated/{}_compartment_annotation.txt'.format(c),sep="\t",index_col=False)
	tmp['chrom'] = 'chr' + tmp['chrom'].astype(str)
	df = pd.concat((df,tmp))

for c in cells:
	tmp = df[['chrom','start',c]]
	atac[c] = pd.merge(tmp,atac[c],how='left',on=['chrom','start']).dropna()
	sns.boxplot(data=atac[c],x=c,y='atac',showfliers=False)
	plt.savefig('figures/per_compartment_{}.pdf'.format(c))
	plt.close()
