import numpy as np
import pandas as pd

chrom = ['chr'+str(i) for i in range(1, 23)]
cells = ['H1','endoderm']
atac = {}
for c in cells:
	tmp = pd.read_csv('atacseq_chipseq_reads_coverage/{}_atacseq.bed'.format(c),sep="\t",header=None,usecols=[0,1,3],names=['chrom','start','atac'],index_col=False)
	atac[c] = tmp 

df = pd.DataFrame()
for c in chrom:
	tmp = pd.read_csv('annotated/{}_compartment_annotation.txt'.format(c),sep="\t",index_col=False)
	tmp['chrom'] = 'chr' + tmp['chrom'].astype(str)
	df = pd.concat((df,tmp))

for c in cells:
	tmp = df[['chrom','start',c]]
	print(tmp)
	print(atac[c])
	atac[c] = pd.merge(tmp,atac[c],how='left',on=['chrom','start']).dropna()
	atac[c] = atac[c].groupby(['chrom',c])['atac'].mean().reset_index()	
	atac[c] = atac[c].pivot(index='chrom',columns=c,values='atac').reset_index()
	atac[c]['chrom'] = atac[c]['chrom'].str.removeprefix('chr').astype(int)
	atac[c].sort_values(by='chrom',inplace=True)
	atac[c].to_csv('mean_atac_per_compartment/{}.txt'.format(c),sep="\t",index=False)


