import numpy as np
import pandas as pd

chrom = ['chr'+str(i) for i in range(1, 20)]
cells = ['ES','NPC','CN']
d1 = {0:'A',1:'B'}
d2 = {0:'B',1:'A'}

meangc = pd.read_csv('mean_gc_per_cluster/ES.txt',sep="\t",index_col=False)

for _,row in meangc.iterrows():
    chro = row['chrom'] #'chr' + str(int(row['chrom']))
    mean0 = row['cluster0']
    mean1 = row['cluster1']
    #print(chro,mean0,mean1)
    df = pd.read_csv('annotated/{}_100kb.bed'.format(chro),sep="\t",index_col=False)
    df.dropna(inplace=True)
    for cell in cells:
        if mean0 > mean1:
            df[cell] = df[cell].astype(int).map(d1)
        else:
            df[cell] = df[cell].astype(int).map(d2)
    df.to_csv('annotated/{}_compartment_annotation.txt'.format(chro),sep="\t",index=False)

