import numpy as np
import pandas as pd
import sys

cells = ['ES']
chroms = ['chr'+str(x) for x in range(1, 20)]
sizes = pd.DataFrame()
for chro in chroms:
    for cell in cells:
        df = pd.read_csv('output/{}_{}_10kb.txt.domain'.format(cell,chro),sep="\t",index_col=False)
        tmp = pd.DataFrame({'size':df['size'].values})
        tmp['chro'] = chro
        sizes = pd.concat((sizes,tmp))

sizes['method'] = 'TopDom'
sizes.to_csv('tad_sizes.txt',sep="\t",index=False,float_format='%d') 
