import numpy as np
import pandas as pd
import sys

cells = ['ES']
chroms = ['chr'+str(x) for x in range(1, 20)]
sizes = pd.DataFrame()
for chro in chroms:
    df = pd.read_csv('output/{}/significant_boundaries_summit_only.txt'.format(chro),sep="\t",index_col=False)
    df.dropna(inplace=True)
    for cell in cells:
        boundary_indices = np.nonzero(df[cell].values)
        tad_sizes = np.diff(boundary_indices)* 10000
        tmp = pd.DataFrame({'size':tad_sizes[0]})
        tmp['chro'] = chro
        sizes = pd.concat((sizes,tmp))

sizes['method'] = 'TGIF-DB'
sizes.to_csv('tad_sizes.txt',sep="\t",index=False) 
