import numpy as np
import pandas as pd
import sys

cells = ['ES']
chroms = ['chr'+str(x) for x in range(1, 20)]
sizes = pd.DataFrame()
for chro in chroms:
    for cell in cells:
        df = pd.read_csv('output/{}_{}_10kb.tads'.format(cell,chro),sep="\t",index_col=False,header=None,names=['start','end'])
        df['size'] = df.end - df.start + 10000 
        tmp = pd.DataFrame({'size':df['size'].values})
        tmp['chro'] = chro
        sizes = pd.concat((sizes,tmp))

sizes['method'] = 'GRiNCH'
sizes.to_csv('tad_sizes.txt',sep="\t",index=False,float_format='%d') 
