import pandas as pd
import sys
import seaborn as sns
import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42

df= pd.DataFrame()
for method in ['grinch','spectraltad','tgif','topdom']:
    tmp = pd.read_csv('{}/tad_sizes.txt'.format(method),sep="\t",index_col=False)
    df = pd.concat((df,tmp))

df['<20kb'] = (df['size'] < 20000)
small = df[['method','<20kb']].groupby(['method']).agg(['sum','count']).reset_index()
small.to_csv('singleton_tad_count.txt',sep="\t",index=False,float_format='%d')

palette=['#44bb99', '#bbcc33', '#ee8866', '#ffaabb']
sns.boxplot(data=df,x='method',y='size',palette=palette,showfliers=False)
plt.savefig('tad_sizes.pdf')

