from sklearn.metrics import rand_score
import pandas as pd
import numpy as np

hyperparameter = ['1010','5811','6060','8912']

cells = ['ES','NPC','CN']

chros = ['chr'+str(i) for i in range(1,20)]
#chros.append('chrX')

dfs = {}
for h in hyperparameter:
	df = pd.DataFrame()
	for chro in chros:
		temp = pd.read_csv('subcomp/output_{}/{}/cluster_assignment.txt'.format(h,chro),sep="\t",index_col=False)
		temp.dropna(inplace=True)
		df = pd.concat((df,temp))
	dfs[h] = df

with open('seed_subcomp.txt','w') as o:
	o.write('Param1\tParam2\tCell\tRand Index\n')
	for i in range(len(hyperparameter)):
		one = hyperparameter[i]
		df1 = dfs[one]
		for j in range(i+1,len(hyperparameter)):
			two = hyperparameter[j]
			df2 = dfs[two]
			#ri = rand_score(df1[cells].values.flatten(), df2[cells].values.flatten())
			#o.write('{}\t{}\toverall\t{:.3f}\n'.format(one,two,ri))
			for cell in cells:
				ri = rand_score(df1[cell],df2[cell])
				o.write('{}\t{}\t{}\t{:.3f}\n'.format(one,two,cell,ri))
			
