import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42

df = pd.read_csv('seed_subcomp.txt',sep="\t",index_col=False)
df = df.groupby(['Param1','Param2']).mean().reset_index()
#for cell in ['overall']: #'ES','NPC','CN']:
#	subdf = df.loc[df.Cell == cell].copy()
temp = df.pivot('Param1','Param2','Rand Index')
sns.heatmap(temp,cmap='Greens',vmin=0.5,vmax=1,annot=True,fmt=".3f")
plt.savefig('seed_subcomp.pdf')
