import pandas as pd
import numpy as np
from scipy.stats import spearmanr, pearsonr
import matplotlib.pyplot as plt
import seaborn as sns
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42

scc = pd.read_csv('oe_correlation.txt',sep="\t",index_col=False)
jac = pd.read_csv('cluster_rand_index.txt',sep="\t",index_col=False)

df = pd.merge(jac,scc,how="left",on=['chrom','A','B'])

#alphas = [100, 10000, 1000000, 100000000]
#subset = [1,10,22]
#o = open('correlation_per_alpha.txt','w')
#o.write('alpha\tpearson\n')
#for a in alphas:
#   subdf = df.loc[(df.alpha == a)]
#   r = pearsonr(subdf.scc, subdf.jaccard)[0]
#   o.write('{}\t{:.3f}\n'.format(a,r))
#o.close()

#sub = df.loc[df.chrom.isin(['chr{:d}'.format(c) for c in subset])]
g = sns.FacetGrid(df, col="alpha",row="chrom")
g.map(sns.scatterplot, "pearsonr", "rand")
plt.savefig('pearsonr_vs_rand.pdf')
#plt.close()
