import pandas as pd
import numpy as np
from scipy.stats import spearmanr, pearsonr

scc = pd.read_csv('oe_correlation.txt',sep="\t",index_col=False)
jac = pd.read_csv('cluster_rand_index.txt',sep="\t",index_col=False)

df = pd.merge(jac,scc,how="left",on=['chrom','A','B'])

alphas = [100, 10000, 1000000, 100000000]
chroms = ['chr'+str(i) for i in range(1,20)]

o = open('correlation_bt_corr_and_rand.txt','w')
o.write('alpha\tchrom\tpearson\tspearman\n')
for a in alphas:
    tmp = df.loc[(df.alpha == a)]
    s = spearmanr(tmp.pearsonr, tmp.rand)[0]
    r = pearsonr(tmp.pearsonr, tmp.rand)[0]
    o.write('{:E}\t{}\t{:.3f}\t{:.3f}\n'.format(a,'overall',r,s))
    for c in chroms:
        subdf = df.loc[(df.alpha == a) & (df.chrom == c)]
        s = spearmanr(subdf.pearsonr, subdf.rand)[0]
        r = pearsonr(subdf.pearsonr, subdf.rand)[0]
        o.write('{:E}\t{}\t{:.3f}\t{:.3f}\n'.format(a,c,r,s))

o.close()
