from sklearn.metrics import rand_score
import pandas as pd
import numpy as np

hyperparameter = [1e2, 1e4, 1e6, 1e8] #'alpha100','alpha10000','alpha1000000','alpha100000000']

cells = ['ES','NPC','CN']
T = len(cells)

chros = ['chr'+str(i) for i in range(1,20)]

o = open('cluster_rand_index.txt','w')
o.write('alpha\tchrom\tA\tB\trand\n')
for h in hyperparameter:
	for chro in chros:
		temp = pd.read_csv('scan_alpha/output_alpha{:d}/{}/cluster_assignment.txt'.format(int(h),chro),sep="\t",index_col=False)
		temp.dropna(inplace=True)
		for i in range(T):
			one = temp.values[:,i]
			for j in range(i+1,T):
				two = temp.values[:,j]
				ri = rand_score(one,two)
				o.write('{}\t{}\t{}\t{}\t{:.3f}\n'.format(h,chro,cells[i],cells[j],ri))
o.close()
			
