import pandas as pd
import numpy as np
from scipy.stats import pearsonr

timepoints = ['ES','NPC','CN']
chroms= ['chr'+str(i) for i in range(1,20)]
T = len(timepoints)

o = open('oe_correlation.txt','w')
o.write('chrom\tA\tB\tpearsonr\n')

for c in chroms:
	for i in range(T):
		X1 = np.loadtxt('tgif_output/{}/{}_oe.txt'.format(c,timepoints[i])).flatten()
		for j in range(i+1,T):
			X2 = np.loadtxt('tgif_output/{}/{}_oe.txt'.format(c,timepoints[j])).flatten()
			r = pearsonr(X1, X2)[0]
			o.write('{}\t{}\t{}\t{:.3f}\n'.format(c,timepoints[i],timepoints[j],r))

o.close()
			
