import pandas as pd
import numpy as np
import sys
import matplotlib.pyplot as plt
import seaborn as sns
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42

df = pd.read_csv('distance.txt',sep="\t",index_col=False)
p1 = df.pivot(index='one',columns='two',values='scc')
sns.heatmap(p1,vmin=0.6,vmax=1,cmap='Greens',annot=True,fmt=".3f")
plt.savefig('scc.pdf')
plt.clf()
p2 = df.pivot(index='one',columns='two',values='dist')
sns.heatmap(p2, vmin=0,vmax=0.3,cmap='Oranges',annot=True,fmt=".3f")
plt.savefig('dist.pdf')

