import pandas as pd
import seaborn as sns
import sys
import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42

mode=sys.argv[1]
df = pd.DataFrame()
for prefix in ['zhang_data','bonev_data','h1_endoderm']:
	tmp = pd.read_csv('{}/{}_memory_and_time.txt'.format(prefix,mode),sep="\t",index_col=False)
	df = pd.concat((df,tmp))
print(df)
sns.scatterplot(data=df,x='n',y='time(seconds)',style='T',hue='T',markers=['$2$','$3$','$6$'],palette={2:'#f67e4b',3:'#dd3d2d',6:'#a50026'},linewidth=0)
plt.savefig('{}_time.pdf'.format(mode))
