import pandas as pd
import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42
sns.set_context("talk")

df = pd.read_csv('interseed_similarity.txt',sep="\t",index_col=False,dtype={'seed1':int,'seed2':int,'jaccard':float})
equiv = {5811:'seed 1',6060:'seed 2', 1010:'seed 3', 8912:'seed 4'}
df['seed1_map'] = df['seed1'].map(equiv)
df['seed2_map'] = df['seed2'].map(equiv)
print(df)
df = df.pivot('seed1_map','seed2_map','jaccard')

sns.heatmap(df,cmap="Greens",annot=True,fmt=".2f",vmin=0.5,vmax=1)
plt.savefig('interseed_similarity.pdf')
