import pandas as pd
import numpy as np
from scipy.stats import spearmanr, pearsonr
import matplotlib.pyplot as plt
import seaborn as sns
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42

scc = pd.read_csv('scc_by_chrom.txt',sep="\t",index_col=False)
jac = pd.read_csv('boundary_jaccard.txt',sep="\t",index_col=False)

df = pd.merge(jac,scc,how="left",on=['chro','A','B'])

#alphas = [100, 10000, 1000000, 100000000]

#o = open('correlation_per_alpha.txt','w')
#o.write('alpha\tpearson\n')
#for a in alphas:
#   subdf = df.loc[(df.alpha == a)]
#   r = pearsonr(subdf.scc, subdf.jaccard)[0]
#   o.write('{}\t{:.3f}\n'.format(a,r))
#o.close()

"""
for c in [1,10,22]: 
    sub = df.loc[df.chro == 'chr{:d}'.format(c)]
    g = sns.FacetGrid(sub, col="alpha")
    g.map(sns.scatterplot, "scc", "jaccard")
    plt.savefig('correlation_chr1.pdf')
    plt.close()
"""
subset=[1,10,22]
df = df.loc[df.chro.isin(['chr{:d}'.format(c) for c in subset])]
g = sns.FacetGrid(df, col="alpha",row="chro")
g.map(sns.scatterplot, "scc", "jaccard")
plt.savefig('scc_vs_jaccard.pdf')

