import pandas as pd
import numpy as np
from scipy.stats import spearmanr, pearsonr

scc = pd.read_csv('scc_by_chrom.txt',sep="\t",index_col=False)
jac = pd.read_csv('boundary_jaccard.txt',sep="\t",index_col=False)

df = pd.merge(jac,scc,how="left",on=['chro','A','B'])

alphas = [100, 10000, 1000000, 100000000]
chros = ['chr'+str(i) for i in range(1,23)]

o = open('correlation_bt_scc_and_jaccard.txt','w')
o.write('alpha\tchrom\tpearson\tspearman\n')
for a in alphas:
	for c in chros:
		subdf = df.loc[(df.alpha == a) & (df.chro == c)]
		s = spearmanr(subdf.scc, subdf.jaccard)[0]
		r = pearsonr(subdf.scc, subdf.jaccard)[0]
		o.write('{:E}\t{}\t{:.3f}\t{:.3f}\n'.format(a,c,r,s))

o.close()
