import pandas as pd
import numpy as np

alphas = [100, 10000, 1000000, 100000000]
A = len(alphas)
timepoints = ['day'+str(i) for i in [0,2,5,7,15,80]]
T = len(timepoints)
chros = ['chr'+str(i) for i in range(1,23)]
o = open('boundary_jaccard.txt','w')
o.write('alpha\tchro\tA\tB\tjaccard\n')

for a in range(A):
	for c in chros:
		df = pd.read_csv('scan_alpha/output_{:d}/{:}/significant_boundaries_summit_only.txt'.format(alphas[a],c),sep="\t",index_col=False)
		for i in range(T):
			for j in range(i+1,T):
				x = df.values[:,i]
				y = df.values[:,j]
				union = np.sum(np.logical_or(x,y))
				inter = np.sum(np.logical_and(x,y))
				o.write('{:.1E}\t{}\t{}\t{}\t{:.3f}\n'.format(alphas[a],c,timepoints[i],timepoints[j],inter/union))

o.close()
