import pandas as pd
import numpy as np
import sys
from scipy.sparse import coo_matrix,csr_matrix
from hicrep import scc
#import dsc as scc
#import matplotlib.pyplot as plt
#import seaborn as sns
#import matplotlib as mpl
#mpl.rcParams['pdf.fonttype'] = 42
#mpl.rcParams['ps.fonttype'] = 42

def readSparseMatrix(fname,n):
	df = pd.read_csv(fname, sep="\t",index_col=False, header=None, names=['i','j','cnt'])
	temp1 = df.loc[df.i != df.j]
	temp2 = pd.DataFrame({'i':temp1.j,'j':temp1.i,'cnt':temp1.cnt})
	df = pd.concat((df, temp2))
	M = coo_matrix((df.cnt,(df.i,df.j)),shape=(n,n))
	return M

chroms = range(1,23)
sccdf = pd.DataFrame()
timepoints = ['day'+str(i) for i in [0,2,5,7,15,80]]
for c in chroms: 
	tableFile = 'input/tree/local/chr{:d}_10kb_tree.txt'.format(c)
	bedFile = 'input/bed/chr{:d}_10kb.bed'.format(c) 

	bed = pd.read_csv(bedFile, sep="\t", index_col=False, header=None, names=['chrom','start','end','idx'])
	n = bed.shape[0]
	resolution = int(bed.end.values[0] - bed.start.values[0])

	df = pd.read_csv(tableFile, sep="\t", index_col=False, header=None, names=['id','parent','alias','fname'])
	matrices = []
	for idx, row in df.iterrows():
		if idx < 6:
			print(row.fname)
			X = readSparseMatrix(row.fname, n)
			matrices.append(X)

	maxDiag = max(100, int(1000000/resolution))
	maxDiag = min(n, maxDiag)
	T = len(matrices)
	dist = []
	a = []
	b = []
	for i in range(T):
		for j in range(i+1,T):
			d = scc.sccByDiag(matrices[i],matrices[j],maxDiag) 
			dist.append(d)
			a.append(timepoints[i])
			b.append(timepoints[j])
	tmp = pd.DataFrame({'scc':dist,'A':a,'B':b})
	tmp['chro'] = 'chr'+str(c)
	sccdf = pd.concat((sccdf,tmp))
	
sccdf.to_csv('scc_by_chrom.txt',sep="\t",float_format="%.3f",index=False)
 
