import pandas as pd
import sys

radius = 100
timepoints = ['ES','NPC','CN']
T = len(timepoints)

for i in range(T):
	t1 = timepoints[i]
	for j in range(i+1,T):
		t2 = timepoints[j]
		pair = '{}vs{}'.format(t1,t2)
		df = pd.read_csv('../../rank_boundaries_{}.txt'.format(pair),sep="\t",index_col=False,usecols=['chro','start','end'])
		df = df.head(10)
		bed = pd.read_csv('all_regions.bed',sep="\t",index_col=False,header=None,usecols=[0,1,3],names=['chro','start','idx'])
		df = pd.merge(df,bed,how='inner',on=['chro','start'])
		for idx, row in df.iterrows():
			midpoint = row['idx']
			start = midpoint - radius
			end = midpoint + radius - 1
			chro = row.chro #'chr' + str(int(row['chro']))
			for cell in [t1,t2]:
				fname = 'hic/count/{}_{}_10kb.txt'.format(cell,chro)
				hicmat = pd.read_csv(fname,sep="\t",header=None,names=['i','j','cnt'])
				submat = hicmat.loc[hicmat['i'].between(start,end) & hicmat['j'].between(start,end)].copy()
				submat['i'] = (submat['i'] - start).astype(int)
				submat['j'] = (submat['j'] - start).astype(int)
				submat.to_csv('submatrix/{}_{}_{}.txt'.format(pair,idx,cell),sep="\t",index=False,header=False)
