import numpy as np
import pandas as pd
import sys

radius = 100
binsize = 10000

timepoints = ['ES','NPC','CN']
T = len(timepoints)

for i in range(T):
	t1 = timepoints[i]
	for j in range(i+1,T):
		t2 = timepoints[j]
		pair = '{}vs{}'.format(t1,t2)
		df = pd.read_csv('../../rank_boundaries_{}.txt'.format(pair),sep="\t",index_col=False,usecols=['chro','start','end'])
		df = df.head(10)
		bed = pd.read_csv('all_regions.bed',sep="\t",index_col=False,header=None,usecols=[0,1,3],names=['chro','start','idx'])
		df = pd.merge(df,bed,how='inner',on=['chro','start'])
		for idx, row in df.iterrows():
			midpoint = int(row['idx'])
			start = int(row['start']-radius*binsize)
			end = int(row['start']+radius*binsize)
			with open('config/{}_{}.ini'.format(pair,idx),'w') as o:
				o.write("[coordinates]\n")
				o.write("chro={}\n".format(row.chro)) #'chr'+str(int(row['chro']))))
				o.write("start={:d}\n".format(start))
				o.write("end={:d}\n".format(end))
				o.write("binsize={:d}\n".format(binsize))

				o.write("\n[content]\n")
				o.write("contexts={},{}\n".format(t1,t2))
				o.write("signals=score,sig,rnaseq,gene\n")
		
				o.write("\n[hicfiles]\n")
				o.write("file0=input/submatrix/{}_{:d}_{}.txt\n".format(pair,idx,t1))
				o.write("file1=input/submatrix/{}_{:d}_{}.txt\n".format(pair,idx,t2))

				o.write("\n[genefiles]\n")
				o.write("file0=/mnt/dv/wid/projects2/Roy-common/data/data_new/mouse/hic/bonev_2017/rnaseq/differential_expression/expression_calculated/{}_merged.txt\n".format(t1))
				o.write("file1=/mnt/dv/wid/projects2/Roy-common/data/data_new/mouse/hic/bonev_2017/rnaseq/differential_expression/expression_calculated/{}_merged.txt\n".format(t2))

				o.write("\n[files]\n")
				o.write("score=input/scores/{}_{:d}_score.txt\n".format(pair,idx))
				o.write("sig=input/summit/{}_{:d}_summit.txt\n".format(pair,idx))
				o.write("output=output/{}_{:d}\n".format(pair,idx))
