import pandas as pd
import numpy as np

timepoints = ['ES','NPC','CN']
T = len(timepoints)

for i in range(T):
	for j in range(i+1,T):
		pair = '{}vs{}'.format(timepoints[i],timepoints[j])
		print(pair)
		df = pd.read_csv('closest_de_gene_to_sig_db_{}.bed'.format(pair),sep="\t",header=None,index_col=False,names=['chro','start','end','db_pval','gene_chro','gene_start','gene_end','gene','de_pval','distance'])
		df['db_pval_rank'] = df['db_pval'].rank(method='dense',ascending=True).astype(int)
		df['nearest_de_pval_rank'] = df['de_pval'].rank(method='dense',ascending=True).astype(int)
		df['average_rank'] = (df['db_pval_rank']+df['nearest_de_pval_rank'])/2.0
		df.sort_values('average_rank',ascending=True,inplace=True)
		df.reset_index(inplace=True)
		del df['index']
		df.to_csv('rank_boundaries_{}.txt'.format(pair),sep="\t") #,float_format='%.3f')	

