import pandas as pd
import numpy as np
import seaborn as sns
import upsetplot as up
import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42

cells = ['day'+str(i) for i in [0,2,5,7,15,80]]
chroms = ['chr'+str(i) for i in range(1,23)]

df = pd.DataFrame()
for c in chroms:
	tmp = pd.read_csv('db_output/{}/significant_boundaries_summit_only.txt'.format(c), sep="\t",index_col=False)
	df = pd.concat((df,tmp))
 
#for_ordering = []
#i = 1
#for cell in cells:
#	for_ordering.append('{:d}.{}'.format(i,cell))
#	i+=1
#df.columns = for_ordering
df.dropna(inplace=True)
df['any'] = df[cells].values.sum(axis=1)
df = df.loc[df['any'] > 0]
grouped = df.groupby(cells).size()
print(grouped)
up.plot(grouped, show_counts=True, sort_categories_by='input', orientation="vertical")
plt.savefig('upset_cardio.pdf')
plt.close()

