import pandas as pd
import numpy as np
from sklearn.metrics import rand_score

chros = ['chr'+str(i) for i in range(1,23)]
days = [0, 2, 5, 7, 15, 80] #'day0','day2','day5','day7','day15','day80']
T = len(days)
tally = {}
for i in range(T):
	dayi = days[i]
	tally[dayi] = {}
	for j in range(i+1, T):
		dayj = days[j]
		tally[dayi][dayj] = 0
		
for c in chros:
	df = pd.read_csv('dc_output/{}/cluster_assignment.txt'.format(c),sep="\t",index_col=False)
	df.dropna(inplace=True)
	for i in range(T):
		dayi = 'day'+str(days[i])
		for j in range(i+1,T):
			dayj = 'day'+str(days[j])
			tally[days[i]][days[j]] += rand_score(df[dayi],df[dayj])

with open('rand_index.txt','w') as o:
	o.write('one\ttwo\tRand Index\n')
	for i in range(T):
		dayi = days[i]
		for j in range(i+1,T):
			dayj = days[j]
			ri = tally[dayi][dayj]/22.0
			o.write('{:d}\t{:d}\t{:.3f}\n'.format(dayi,dayj,ri))
			#o.write('{}\t{}\t{:.3f}\n'.format(dayj,dayi,ri))


