from scipy.spatial.distance import pdist, squareform
import pandas as pd
import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt
import sys

o = open('jaccard_index.txt','w')
o.write('one\ttwo\tjaccard\n')
names=["ES","NPC","CN"]
chros = ['chr'+str(i) for i in range(1,20)]
chros.append('chrX')
t = len(names)
intersection = np.zeros((t,t))
union = np.zeros((t,t))

for chro in chros:
	sigs = pd.read_csv('tgif_output/{}/significant_boundaries_summit_only.txt'.format(chro),sep="\t",index_col=False)
	sigs.fillna(0,inplace=True)
	sigs = sigs.values.T
	for i in range(t):
		intersection[i,i] = 1
		union[i,i] = 1
		for j in range(i+1,t):
			u_cnt = np.sum(np.logical_or(sigs[i],sigs[j]))
			i_cnt = np.sum((sigs[i]+sigs[j])==2)
			union[i,j]+=u_cnt
			union[j,i]+=u_cnt
			intersection[i,j]+=i_cnt
			intersection[j,i]+=i_cnt
			
jaccard = intersection/union
for i in range(t):
	for j in range(t):
		o.write('{:d}){:}\t{:d}){:}\t{:.3f}\n'.format(i+1,names[i],j+1,names[j],jaccard[i,j]))
o.close()

