import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt
import numpy as np
import sys
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42
sns.set_context("talk")

df = pd.read_csv('jaccard_index.txt',sep="\t",index_col=False)
df = df.pivot("one","two","jaccard")
fig = plt.figure(figsize=(10,8))
sns.heatmap(df, cmap="Greens",vmin=0.2, vmax=0.7,annot=True,fmt=".3f",cbar_kws={'label':'Jaccard Index'})
#ax = sns.violinplot(y='-log(pval+e-5)',x='config',data=df,palette='Set2')
#ax = sns.swarmplot(x='config',y='score',hue='type',data=df)
#ax.set_yscale("log")
plt.xlabel('timepoint')
plt.ylabel('timepoint')
plt.tight_layout()
plt.savefig('jaccard_index.pdf')
