import pandas as pd
import numpy as np
import seaborn as sns
import string
import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42
mpl.rcParams['ps.fonttype'] = 42

days = ['H1','endoderm']
T = len(days)

big = pd.DataFrame()
for i in range(T-1):
	d1 = days[i]
	for j in range(i+1,T):
		d2 = days[j]
		pair = '{}vs{}'.format(d1,d2)
		print(d1,d2)

		df = pd.read_csv('../go_enrichment/{}_details.txt'.format(pair), sep="\t",header=None,index_col=False,usecols=[0,1,3],names=['cluster','term','padj'])

		df = df.loc[(df['cluster'].isin((1,3))) & (df['padj']<1e-5)]
		df['-log(padj)'] = -1 * np.log(df['padj']) 

		clustermap = {1:'{}: DE NOT near DB'.format(pair),3:'{}: DE near DB'.format(pair)}
		df['cluster'] = df['cluster'].map(clustermap)
		big = pd.concat((big,df))

big = big.pivot('term','cluster','-log(padj)').reset_index()
#big.to_csv('test.txt',sep="\t",index=False)
#big = df.sort_values([3,1],ascending=False)

excel_file='top_terms.xlsx'
sheet_name='Sheet1'

writer = pd.ExcelWriter(excel_file, engine='xlsxwriter')
big.to_excel(writer, sheet_name=sheet_name,index=False,float_format='%.1f')

workbook = writer.book
worksheet = writer.sheets[sheet_name]

srange = 'B2:'+ string.ascii_uppercase[big.shape[1]] + str(big.shape[0]+1)
worksheet.conditional_format(srange, {'type': '2_color_scale','min_color':'#FFFFFF','max_color':'#0093FF'})
writer.save()
