import numpy as np
import pandas as pd
import sys

radius = 100
timepoints = ['day00','day80'] #,'day05','day07','day15','day80']

T = len(timepoints)
df = pd.read_csv('../../common_bondaries_with_snp.txt',sep="\t",index_col=False)
for i in range(T):
	t1 = timepoints[i]
	for j in range(i+1,T):
		t2 = timepoints[j]
		for idx, row in df.iterrows():
			midpoint = int(row['idx'])
			start = midpoint - radius
			end = midpoint + radius
			chro = 'chr'+str(int(row['chro']))
			scores = pd.read_csv('tgif_output/{}/significant_boundaries_summit_only.txt'.format(chro), sep="\t",index_col=False)
			scores.fillna(0,inplace=True)
			scores = scores.values[start:end]
			subset = scores[:,[i,j]]
			np.savetxt('summit/{:d}_summit.txt'.format(idx),subset,delimiter="\t",fmt="%d")	

