import pandas as pd
import sys

radius = 100
timepoints = ['day00','day80'] #,'day05','day07','day15','day80']

T = len(timepoints)
df = pd.read_csv('../../common_bondaries_with_snp.txt',sep="\t",index_col=False)
for i in range(T):
	t1 = timepoints[i]
	for j in range(i+1,T):
		t2 = timepoints[j]
		for idx, row in df.iterrows():
			midpoint = row['idx']
			start = midpoint - radius
			end = midpoint + radius - 1
			chro = 'chr' + str(int(row['chro']))
			for cell in [t1,t2]:
				fname = 'hic/mat/{}_{}_10kb.txt'.format(cell,chro)
				hicmat = pd.read_csv(fname,sep="\t",header=None,names=['i','j','cnt'])
				submat = hicmat.loc[hicmat['i'].between(start,end) & hicmat['j'].between(start,end)].copy()
				submat['i'] = (submat['i'] - start).astype(int)
				submat['j'] = (submat['j'] - start).astype(int)
				submat.to_csv('submatrix/{}_{}.txt'.format(idx,cell),sep="\t",index=False,header=False)
