import numpy as np
import pandas as pd
import sys

radius = 100
timepoints = ['day00','day80'] #,'day05','day07','day15','day80']

T = len(timepoints)
df = pd.read_csv('../../common_bondaries_with_snp.txt',sep="\t",index_col=False)
for i in range(T):
	t1 = timepoints[i]
	for j in range(i+1,T):
		t2 = timepoints[j]
		for idx, row in df.iterrows():
			midpoint = int(row['idx'])
			start = midpoint - radius
			end = midpoint + radius
			chro = 'chr' + str(int(row['chro']))
			scores = pd.read_csv('tgif_output/{}/boundary_score.txt'.format(chro), sep="\t",index_col=False)
			scores.fillna(0,inplace=True)
			scores = scores.values[start:end]
			scores = scores[:,[i,j]]
			np.savetxt('scores/{:d}_score.txt'.format(idx),scores,delimiter="\t",fmt="%.3f")	
