import numpy as np
import pandas as pd
import sys

radius = 100
binsize = 10000

timepoints = ['day00','day80']
T = len(timepoints)
df = pd.read_csv('../../common_bondaries_with_snp.txt',sep="\t",index_col=False)
for i in range(T):
	t1 = timepoints[i]
	for j in range(i+1,T):
		t2 = timepoints[j]
		#pair = '{}_vs_{}'.format(t1,t2)
		for idx, row in df.iterrows():
			midpoint = int(row['idx'])
			start = int(row['start']-radius*binsize)
			end = int(row['start']+radius*binsize)
			with open('config/{}.ini'.format(idx),'w') as o:
				o.write("[coordinates]\n")
				o.write("chro={}\n".format('chr'+str(int(row['chro']))))
				o.write("start={:d}\n".format(start))
				o.write("end={:d}\n".format(end))
				o.write("binsize={:d}\n".format(binsize))

				o.write("\n[content]\n")
				o.write("contexts={},{}\n".format(t1,t2))
				o.write("signals=score,sig,rnaseq,gene\n")
		
				o.write("\n[hicfiles]\n")
				o.write("file0=input/submatrix/{:d}_{}.txt\n".format(idx,t1))
				o.write("file1=input/submatrix/{:d}_{}.txt\n".format(idx,t2))

				o.write("\n[genefiles]\n")
				o.write("file0=/mnt/dv/wid/projects7/Roy-enhancer-promoter-2/DATA/Zhang_2019/rnaseq/expression_calculated/{}_merged.txt\n".format(t1))
				o.write("file1=/mnt/dv/wid/projects7/Roy-enhancer-promoter-2/DATA/Zhang_2019/rnaseq/expression_calculated/{}_merged.txt\n".format(t2))

				o.write("\n[files]\n")
				o.write("score=input/scores/{:d}_score.txt\n".format(idx))
				o.write("sig=input/summit/{:d}_summit.txt\n".format(idx))
				o.write("output=output/{:d}\n".format(idx))
