import pandas as pd
import sys
import numpy as np
import sys

parent_term = 'cardiovascular_disease' #sys.argv[1]
# HiC resolution used for analysis
binsize = 10000 
# directory containing TADs
filedir = '../tgif_output/'

chros = ['chr'+str(i) for i in range (1,23)]
bigdf = pd.DataFrame()
for chro in chros:
	df = pd.read_csv('bed/{}_10kb.bed'.format(chro),sep="\t",header=None,names=['chro','start','end','idx'])
	sig = pd.read_csv('../tgif_output/{:}/significant_boundaries_summit_only.txt'.format(chro),sep="\t",index_col=False)
	sig.fillna(0,inplace=True)
	sig = sig.values
	sig = np.sum(sig,axis=1)
	sig = (sig == 6)
	df['Common boundary'] = sig
	df['SNP count'] = np.loadtxt('map_snps_to_bins/{}/{}_snp_count.txt'.format(parent_term,chro))
	df = df.loc[df['Common boundary'] & (df['SNP count'] > 0)].copy()	
	temp = pd.read_csv('map_snps_to_bins/{}/{}_snp_and_gene.txt'.format(parent_term,chro),index_col=False,sep="\t")
	df = pd.merge(df,temp,how='left',on='idx')
	bigdf = pd.concat((bigdf,df),ignore_index=True)
bigdf.to_csv('common_boundaries_with_snp.txt',sep="\t")
