import pandas as pd

snps = pd.read_csv('gwasCatalog.txt',sep="\t",header=None,usecols=[1,2,3,4,10,14],index_col=False,names=['chro','loc','end','id','trait','reported_gene'])
maps = pd.read_csv('mapping.txt',sep="\t",usecols=['Disease trait','EFO term','Parent term'],index_col=False)
parent_terms = maps['Parent term'].unique()
for term in parent_terms:
	subset = maps.loc[maps['Parent term'] == term].copy()
	df = pd.merge(subset,snps,how='inner',left_on='Disease trait',right_on='trait')
	df['bin'] = (df['loc'].values/10000).astype(int) * 10000
	df.to_csv('snps_by_parent_term/{}.txt'.format(term.lower().replace(" ","_")),sep="\t",index=False,columns=['id','chro','loc','bin','trait','EFO term','reported_gene'])
