import pandas as pd

snps = pd.read_csv('gwasCatalog.txt',sep="\t",header=None,usecols=[1,2,3,4,10,14],index_col=False,names=['chro','loc','end','id','trait','reported_gene'])
maps = pd.read_csv('mapping.txt',sep="\t",usecols=['Disease trait','EFO term','Parent term'],index_col=False)
#print(maps['Parent term'].unique())
subset = maps.loc[maps['Parent term'] == 'Cardiovascular disease']

df = pd.merge(subset,snps,how='inner',left_on='Disease trait',right_on='trait')
df['bin'] = (df['loc'].values/10000).astype(int) * 10000
df.to_csv('cardio_snps.txt',sep="\t",index=False,columns=['id','chro','loc','bin','trait','EFO term','reported_gene'])
