import pandas as pd
import numpy as np
import sys

chros = ['chr'+str(i) for i in range(1, 23)]
res = 10000
snps = pd.read_csv('snps/snps_by_parent_term/{}.txt'.format(sys.argv[1]),sep="\t")

for chro in chros:
	bed = pd.read_csv('bed/{}_10kb.bed'.format(chro),header=None, names=['chro','start','end','idx'],index_col=False, sep="\t")
	sublist = snps.loc[snps['chro']==chro]
	vec = np.zeros(bed.shape[0],dtype=int)
	offset = bed['start'].values[0]
	for _,row in sublist.iterrows():
		idx = (row['bin'] - offset)/res
		vec[int(idx)] +=1
	np.savetxt('map_snps_to_bins/{}/{}_snp_count.txt'.format(sys.argv[1], chro),vec,fmt="%d")
	
