import pandas as pd
import seaborn as sns
import numpy as np
import matplotlib.pyplot as plt
import matplotlib as mpl
mpl.rcParams['pdf.fonttype'] = 42

df = pd.read_csv('intersection.txt',sep="\t",index_col=False)
#df['-log(p-value)'] = -1 * np.log(df['Enrichment p-value'])
#df['-log(p-value)'] = -1 * np.log(df['Enrichment p-value'])
df.sort_values('Fold Enrichment',ascending=False,inplace=True) 
print(df)
pal = sns.color_palette("RdPu", len(df))
rank = df[['Enrichment p-value']].rank().astype(int).values.flatten() - 1
sns.barplot(data=df,y='Parent term',x='Fold Enrichment',color="#66ccee")
#sns.barplot(data=df,y='Parent term',x='Fold Enrichment',palette=np.array(pal[::-1])[rank]) #color="#66ccee")
plt.tight_layout()
plt.savefig('intersection.pdf')
